% By Mikolaj Roguski, April 2025
% This code is a part of the data package and can 
% be used for extracting data from .h5 raw data files.

 
clear ;
close all;

% Define file
filename = 'Figure 7/raw data/000114227-RabiFlopExtended_7.h5' ;


% Extract the filenumber from file name (for the legend)
number = regexp(filename, '\d+', 'match'); % get the numbers in the filename
filenumber_str = ['File: ', num2str(str2double(number{2}))] ; % This removes leading zeros

% Read out the file 
xdata = h5read(filename, '/datasets/scan')' *1e6 ; % [us]
ydata = h5read(filename, '/datasets/all_data');
rid_read = h5read(filename, '/rid')' ;
reps = length(ydata)/length(xdata);

% Determine threshold for darks and brights 
enable_hist_plotting = false ; % plot histogram
th = threshold_update(ydata, enable_hist_plotting, rid_read) ;

% Extract state probability from the photon counts 
ydata = ydata<th;
ydata = reshape(ydata, [length(xdata),reps])';
ydata = mean(ydata);
ydata_err = sqrt(ydata.*(1-ydata)/reps);

% Plot figure
figure
errorbar(xdata,ydata,ydata_err, 'o-', 'LineWidth', 2, 'MarkerSize', 10, 'DisplayName', filenumber_str)
legend()

set(0, 'DefaultFigurePosition', [100, 100, 800, 600]);
box on ;
set(gca, 'LineWidth', 1.5)
set(gca, 'FontSize', 18);
set(gca, 'FontName','Avenir Next');